using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerEffects : MonoBehaviour
{
    public float Temperature;
    public float Hunger;
    public float Health;
    public float MaxHealth = 75f;
    public float MaxHunger = 125f;
    public float TemperatureCap = 80f;
    public float HungerLossTime = 8f;
    public float TemperatureDamageTime = 7f;
    bool nearWarmth = false;

    void Awake()
    {
        float Temperature = 50f;
        float Hunger = 125f;
        float Health = 75f;
    }


    // Start is called before the first frame update
    void Start()
    {
        InvokeRepeating("HungerLossRate", 0.25f, HungerLossTime);
        InvokeRepeating("TempOverTime", 0.25f, TemperatureDamageTime);

    }

    // Update is called once per frame
    void Update()
    {

        if (Temperature > TemperatureCap)
        {
            Temperature = TemperatureCap;
        }
        if (Hunger > MaxHunger)
        {
            Hunger = MaxHunger;
        }
        if (Health > MaxHealth)
        {
            Health = MaxHealth;
        }








        
        CheckForDeath();
    }
    public void FixedUpdate()
    {
        CheckForEnvironmentDamage();
    }
    public virtual void HungerLossRate()
    {
        Hunger--;
    }

    //Handles Entering and colliding with all ineractive hitboxes
    private void OnTriggerEnter(Collider other)
    {
        if (other.CompareTag("EnemyAttack"))
        {
            //Code For Attack Damage
            //Health = Health - damage;

        }
        if (other.CompareTag("Item"))
        {
            //Code for Picking up Items
            //Health = Health - damage;

        }
        if (other.CompareTag("Tree"))
        {

            //Make Radius of wind Slightly Larger, near 45
            //Health = Health - damage;

        }
        if (other.CompareTag("Fire"))
        {

            //Make Radius of wind larger, near 75
            //Health = Health - damage;
            nearWarmth = true;
        }
        if (other.CompareTag("Shelter"))
        {

            //Make radius drastically larger, near 120;
            //Health = Health - damage;

        }
        if (other.CompareTag("Radio"))
        {

            //Allow for Radio interaction upon the press of the key 'r'
            //Health = Health - damage;

        }





    }

    void CheckForDeath()
    {
        if(Health <= 0)
        {
            print("You are dead. Oh how sad.");


        }
        else
        {
            print("Wow, you are alive! Crazy.");
        }
    }

    void CheckForEnvironmentDamage()
    {

        if(Temperature <= 15)
        { 
            StartCoroutine("OverTimeDamage");
            print("You're Freezing!");           
        }






    }

    public void TempOverTime()
    {
        while (nearWarmth == true);
        {
            StartCoroutine("GainTemp");
        }
        while (nearWarmth == false) ;
        {
            StartCoroutine("LoseTemp");
        }

    }

    IEnumerator OverTimeDamage()
    {
        yield return new WaitForSeconds(2f);
        Health = Health - 1;
    }

    IEnumerator GainTemp()
    {
        yield return new WaitForSeconds(3f);
        Temperature = Temperature += 1;
    }
    IEnumerator LoseTemp()
    {
        yield return new WaitForSeconds(3f);
        Temperature = Temperature -= 1;
    }

}
